/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.exordium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.exordium.Config;
import dev.tr7zw.exordium.ConfigUpgrader;
import dev.tr7zw.exordium.NametagSettings;
import dev.tr7zw.exordium.SignSettings;
import dev.tr7zw.exordium.config.CustomConfigScreen;
import dev.tr7zw.exordium.util.BufferRenderer;
import dev.tr7zw.exordium.util.DelayedRenderCallManager;
import dev.tr7zw.exordium.util.NametagScreenBuffer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.class_276;
import net.minecraft.class_437;
import net.minecraft.class_7172;

public abstract class ExordiumModBase {
    public static ExordiumModBase instance;
    private static boolean forceBlend;
    private static boolean blendBypass;
    private static int bypassTurnoff;
    public Config config;
    private final File settingsFile = new File("config", "exordium.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private BufferRenderer screenBufferRenderer;
    private NametagScreenBuffer nametagScreenBuffer;
    private class_276 temporaryScreenOverwrite = null;
    public static SignSettings signSettings;
    public static NametagSettings nametagSettings;
    private final DelayedRenderCallManager delayedRenderCallManager = new DelayedRenderCallManager();

    public void onInitialize() {
        instance = this;
        if (this.settingsFile.exists()) {
            try {
                this.config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex) {
                System.out.println("Error while loading config! Creating a new one!");
                ex.printStackTrace();
            }
        }
        if (this.config == null) {
            this.config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(this.config)) {
            this.writeConfig();
        }
        this.initModloader();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)this.config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public BufferRenderer getScreenBufferRenderer() {
        if (this.screenBufferRenderer == null) {
            this.screenBufferRenderer = new BufferRenderer(true);
        }
        return this.screenBufferRenderer;
    }

    public NametagScreenBuffer getNameTagScreenBuffer() {
        if (this.nametagScreenBuffer == null) {
            this.nametagScreenBuffer = new NametagScreenBuffer(1000 / this.config.targetFPSNameTags);
        }
        return this.nametagScreenBuffer;
    }

    public DelayedRenderCallManager getDelayedRenderCallManager() {
        return this.delayedRenderCallManager;
    }

    public abstract void initModloader();

    public class_437 createConfigScreen(class_437 parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.exordium.title"){

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getOnOffOption("text.exordium.enableGui", () -> ExordiumModBase.this.config.enabledGui, b -> {
                    ExordiumModBase.this.config.enabledGui = b;
                }));
                options.add(this.getIntOption("text.exordium.targetFramerateGui", 5, 60, () -> ExordiumModBase.this.config.targetFPSIngameGui, v -> {
                    ExordiumModBase.this.config.targetFPSIngameGui = v;
                }));
                options.add(this.getOnOffOption("text.exordium.enabledGuiAnimationSpeedup", () -> ExordiumModBase.this.config.enabledGuiAnimationSpeedup, b -> {
                    ExordiumModBase.this.config.enabledGuiAnimationSpeedup = b;
                }));
                options.add(this.getIntOption("text.exordium.targetFPSIngameGuiAnimated", 30, 120, () -> ExordiumModBase.this.config.targetFPSIngameGuiAnimated, v -> {
                    ExordiumModBase.this.config.targetFPSIngameGuiAnimated = v;
                }));
                options.add(this.getOnOffOption("text.exordium.enableScreen", () -> ExordiumModBase.this.config.enabledScreens, b -> {
                    ExordiumModBase.this.config.enabledScreens = b;
                }));
                options.add(this.getIntOption("text.exordium.targetFramerateScreen", 20, 120, () -> ExordiumModBase.this.config.targetFPSIngameScreens, v -> {
                    ExordiumModBase.this.config.targetFPSIngameScreens = v;
                }));
                options.add(this.getOnOffOption("text.exordium.enableSignBuffering", () -> ExordiumModBase.this.config.enableSignBuffering, b -> {
                    ExordiumModBase.this.config.enableSignBuffering = b;
                }));
                options.add(this.getOnOffOption("text.exordium.enableNametagScreenBuffering", () -> ExordiumModBase.this.config.enableNametagScreenBuffering, b -> {
                    ExordiumModBase.this.config.enableNametagScreenBuffering = b;
                }));
                options.add(this.getIntOption("text.exordium.targetFPSNameTags", 30, 80, () -> ExordiumModBase.this.config.targetFPSNameTags, v -> {
                    ExordiumModBase.this.config.targetFPSNameTags = v;
                }));
                this.getOptions().method_20408(options.toArray(new class_7172[0]));
            }

            @Override
            public void save() {
                ExordiumModBase.this.writeConfig();
            }

            @Override
            public void reset() {
                ExordiumModBase.this.config = new Config();
                ExordiumModBase.this.writeConfig();
            }
        };
        return screen;
    }

    public static boolean isForceBlend() {
        return forceBlend;
    }

    public static void setForceBlend(boolean forceBlend) {
        ExordiumModBase.forceBlend = forceBlend;
    }

    public static boolean isBlendBypass() {
        return blendBypass;
    }

    public static void setBlendBypass(boolean blendBypass) {
        if (forceBlend && ExordiumModBase.blendBypass && !blendBypass) {
            ExordiumModBase.correctBlendMode();
        }
        ExordiumModBase.blendBypass = blendBypass;
    }

    public static int getBypassTurnoff() {
        return bypassTurnoff;
    }

    public static void setBypassTurnoff(int bypassTurnoff) {
        ExordiumModBase.bypassTurnoff = bypassTurnoff;
    }

    public static void correctBlendMode() {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }

    public class_276 getTemporaryScreenOverwrite() {
        return this.temporaryScreenOverwrite;
    }

    public void setTemporaryScreenOverwrite(class_276 temporaryScreenOverwrite) {
        this.temporaryScreenOverwrite = temporaryScreenOverwrite;
    }

    static {
        signSettings = new SignSettings();
        nametagSettings = new NametagSettings();
    }
}

